<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectChecklist
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int|null $project_phase_id
 * @property int|null $project_elevator_id
 * @property string $title
 * @property string $type
 * @property string|null $description
 * @property string $status
 * @property int $created_by
 * @property int|null $completed_by
 * @property Carbon|null $completed_at
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 * @property InstallationProject $installation_project
 * @property ProjectElevator|null $project_elevator
 * @property ProjectPhase|null $project_phase
 * @property Collection|ProjectChecklistItem[] $project_checklist_items
 *
 * @package App\Models
 */
class ProjectChecklist extends Model
{
	protected $table = 'project_checklists';

	protected $casts = [
		'installation_project_id' => 'int',
		'project_phase_id' => 'int',
		'project_elevator_id' => 'int',
		'created_by' => 'int',
		'completed_by' => 'int',
		'completed_at' => 'datetime'
	];

	protected $fillable = [
		'installation_project_id',
		'project_phase_id',
		'project_elevator_id',
		'title',
		'type',
		'description',
		'status',
		'created_by',
		'completed_by',
		'completed_at',
		'notes'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_elevator()
	{
		return $this->belongsTo(ProjectElevator::class);
	}

	public function project_phase()
	{
		return $this->belongsTo(ProjectPhase::class);
	}

	public function project_checklist_items()
	{
		return $this->hasMany(ProjectChecklistItem::class);
	}
}
