<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PayrollItem
 * 
 * @property int $id
 * @property int $company_id
 * @property int $payroll_id
 * @property int $employee_id
 * @property float $basic_salary
 * @property int $working_days
 * @property int $absent_days
 * @property int $late_minutes
 * @property float $overtime_hours
 * @property float $overtime_amount
 * @property string|null $allowances
 * @property string|null $deductions
 * @property float $gross_salary
 * @property float $tax_amount
 * @property float $social_insurance
 * @property float $net_salary
 * @property string $payment_status
 * @property Carbon|null $payment_date
 * @property string|null $notes
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User|null $user
 * @property Employee $employee
 * @property Payroll $payroll
 *
 * @package App\Models
 */
class PayrollItem extends Model
{
	protected $table = 'payroll_items';

	protected $casts = [
		'company_id' => 'int',
		'payroll_id' => 'int',
		'employee_id' => 'int',
		'basic_salary' => 'float',
		'working_days' => 'int',
		'absent_days' => 'int',
		'late_minutes' => 'int',
		'overtime_hours' => 'float',
		'overtime_amount' => 'float',
		'gross_salary' => 'float',
		'tax_amount' => 'float',
		'social_insurance' => 'float',
		'net_salary' => 'float',
		'payment_date' => 'datetime',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'payroll_id',
		'employee_id',
		'basic_salary',
		'working_days',
		'absent_days',
		'late_minutes',
		'overtime_hours',
		'overtime_amount',
		'allowances',
		'deductions',
		'gross_salary',
		'tax_amount',
		'social_insurance',
		'net_salary',
		'payment_status',
		'payment_date',
		'notes',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'updated_by');
	}

	public function employee()
	{
		return $this->belongsTo(Employee::class);
	}

	public function payroll()
	{
		return $this->belongsTo(Payroll::class);
	}
}
