<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Payroll
 * 
 * @property int $id
 * @property int $company_id
 * @property string $payroll_period
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property int $total_employees
 * @property float $total_basic_salary
 * @property float $total_allowances
 * @property float $total_deductions
 * @property float $total_overtime
 * @property float $total_tax
 * @property float $total_social_insurance
 * @property float $total_net_salary
 * @property string $status
 * @property Carbon|null $payment_date
 * @property string|null $notes
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User|null $user
 * @property Collection|PayrollItem[] $payroll_items
 *
 * @package App\Models
 */
class Payroll extends Model
{
	protected $table = 'payrolls';

	protected $casts = [
		'company_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'total_employees' => 'int',
		'total_basic_salary' => 'float',
		'total_allowances' => 'float',
		'total_deductions' => 'float',
		'total_overtime' => 'float',
		'total_tax' => 'float',
		'total_social_insurance' => 'float',
		'total_net_salary' => 'float',
		'payment_date' => 'datetime',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'payroll_period',
		'start_date',
		'end_date',
		'total_employees',
		'total_basic_salary',
		'total_allowances',
		'total_deductions',
		'total_overtime',
		'total_tax',
		'total_social_insurance',
		'total_net_salary',
		'status',
		'payment_date',
		'notes',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'updated_by');
	}

	public function payroll_items()
	{
		return $this->hasMany(PayrollItem::class);
	}
}
