<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PaymentMethod
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string|null $description
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Collection|Payment[] $payments
 *
 * @package App\Models
 */
class PaymentMethod extends Model
{
	protected $table = 'payment_methods';

	protected $casts = [
		'company_id' => 'int',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'description',
		'is_active'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function payments()
	{
		return $this->hasMany(Payment::class);
	}
}
