<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Payment
 * 
 * @property int $id
 * @property int $company_id
 * @property int $invoice_id
 * @property string|null $payable_type
 * @property int|null $payable_id
 * @property int $payment_method_id
 * @property int $created_by
 * @property float $amount
 * @property Carbon $payment_date
 * @property string|null $reference_number
 * @property string $status
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property User $user
 * @property Invoice $invoice
 * @property PaymentMethod $payment_method
 *
 * @package App\Models
 */
class Payment extends Model
{
	use SoftDeletes;
	protected $table = 'payments';

	protected $casts = [
		'company_id' => 'int',
		'invoice_id' => 'int',
		'payable_id' => 'int',
		'payment_method_id' => 'int',
		'created_by' => 'int',
		'amount' => 'float',
		'payment_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'invoice_id',
		'payable_type',
		'payable_id',
		'payment_method_id',
		'created_by',
		'amount',
		'payment_date',
		'reference_number',
		'status',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}

	public function payment_method()
	{
		return $this->belongsTo(PaymentMethod::class);
	}

	/**
	 * Alias for payment_method relationship
	 */
	public function paymentMethod()
	{
		return $this->payment_method();
	}

	/**
	 * Alias for reference_number attribute
	 */
	public function getReferenceAttribute()
	{
		return $this->reference_number;
	}

	/**
	 * Alias for payment_date attribute
	 */
	public function getDateAttribute()
	{
		return $this->payment_date;
	}
}
