<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Opportunity
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int $user_id
 * @property string $name
 * @property string|null $description
 * @property float $amount
 * @property string $stage
 * @property int $probability
 * @property Carbon|null $expected_close_date
 * @property Carbon|null $actual_close_date
 * @property string|null $source
 * @property string|null $notes
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Customer $customer
 * @property User $user
 *
 * @package App\Models
 */
class Opportunity extends Model
{
	use SoftDeletes;
	protected $table = 'opportunities';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'user_id' => 'int',
		'amount' => 'float',
		'probability' => 'int',
		'expected_close_date' => 'datetime',
		'actual_close_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'user_id',
		'name',
		'description',
		'amount',
		'stage',
		'probability',
		'expected_close_date',
		'actual_close_date',
		'source',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
