<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Notification
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $user_id
 * @property string $type
 * @property string $notifiable_type
 * @property int $notifiable_id
 * @property string $title
 * @property string $message
 * @property string|null $data
 * @property Carbon|null $read_at
 * @property Carbon|null $sent_at
 * @property string $status
 * @property string $priority
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User|null $user
 *
 * @package App\Models
 */
class Notification extends Model
{
	protected $table = 'notifications';

	protected $casts = [
		'company_id' => 'int',
		'user_id' => 'int',
		'notifiable_id' => 'int',
		'read_at' => 'datetime',
		'sent_at' => 'datetime',
		'data' => 'array'
	];

	protected $fillable = [
		'company_id',
		'user_id',
		'type',
		'notifiable_type',
		'notifiable_id',
		'title',
		'message',
		'data',
		'read_at',
		'sent_at',
		'status',
		'priority'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	/**
	 * Mark the notification as read.
	 *
	 * @return $this
	 */
	public function markAsRead()
	{
		if (is_null($this->read_at)) {
			$this->read_at = now();
			$this->save();
		}

		return $this;
	}

	/**
	 * Mark the notification as sent.
	 *
	 * @return $this
	 */
	public function markAsSent()
	{
		if (is_null($this->sent_at)) {
			$this->sent_at = now();
			$this->status = 'sent';

			// No need to manually encode data as JSON since Laravel will handle this
			// through the 'array' cast defined in the $casts property

			$this->save();

			// Log the notification status change
			\Illuminate\Support\Facades\Log::info('تم تحديث حالة الإشعار إلى مرسل', [
				'notification_id' => $this->id,
				'type' => $this->type,
				'title' => $this->title
			]);
		}

		return $this;
	}
}
