<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class MarketingCampaign
 * 
 * @property int $id
 * @property int $company_id
 * @property int $user_id
 * @property string $name
 * @property string|null $description
 * @property string $type
 * @property Carbon $start_date
 * @property Carbon|null $end_date
 * @property float $budget
 * @property float $actual_cost
 * @property string $status
 * @property int $expected_response
 * @property int $actual_response
 * @property string|null $notes
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User $user
 * @property Collection|CampaignMember[] $campaign_members
 *
 * @package App\Models
 */
class MarketingCampaign extends Model
{
	use SoftDeletes;
	protected $table = 'marketing_campaigns';

	protected $casts = [
		'company_id' => 'int',
		'user_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'budget' => 'float',
		'actual_cost' => 'float',
		'expected_response' => 'int',
		'actual_response' => 'int'
	];

	protected $fillable = [
		'company_id',
		'user_id',
		'name',
		'description',
		'type',
		'start_date',
		'end_date',
		'budget',
		'actual_cost',
		'status',
		'expected_response',
		'actual_response',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function campaign_members()
	{
		return $this->hasMany(CampaignMember::class, 'campaign_id');
	}
}
