<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceTeam extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'company_id',
        'leader_id',
        'description',
        'created_by',
        'branch_id',
        'is_active',
    ];

    /**
     * Get the company that owns the team.
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * Get the team leader.
     */
    public function teamLeader()
    {
        return $this->belongsTo(User::class, 'leader_id');
    }

    /**
     * Get the user who created the team.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the members of the team.
     */
    public function members()
    {
        return $this->belongsToMany(User::class, 'maintenance_team_members', 'team_id', 'user_id')
            ->withPivot('role')
            ->withTimestamps();
    }

    /**
     * Get the maintenance schedules assigned to this team.
     */
    public function schedules()
    {
        return $this->hasMany(MaintenanceSchedule::class, 'team_id');
    }

    /**
     * Get the maintenance logs performed by this team.
     */
    public function maintenanceLogs()
    {
        return $this->hasMany(MaintenanceLog::class, 'team_id');
    }

    /**
     * Get the maintenance requests assigned to this team.
     */
    public function maintenanceRequests()
    {
        return $this->hasMany(MaintenanceRequest::class, 'assigned_team_id');
    }

    /**
     * For backward compatibility
     */
    public function leader()
    {
        return $this->teamLeader();
    }
}
