<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class MaintenanceSchedule
 * 
 * @property int $id
 * @property int $maintenance_contract_id
 * @property int $elevator_id
 * @property Carbon $scheduled_date
 * @property string $status
 * @property string|null $notes
 * @property int $company_id
 * @property int $user_id
 * @property int|null $invoice_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Elevator $elevator
 * @property Invoice|null $invoice
 * @property MaintenanceContract $maintenance_contract
 * @property User $user
 * @property Collection|MaintenanceLog[] $maintenance_logs
 *
 * @package App\Models
 */
class MaintenanceSchedule extends Model
{
	protected $table = 'maintenance_schedules';

	protected $casts = [
		'maintenance_contract_id' => 'int',
		'elevator_id' => 'int',
		'scheduled_date' => 'datetime',
		'company_id' => 'int',
		'user_id' => 'int',
		'invoice_id' => 'int',
		'team_id' => 'int'
	];

	protected $fillable = [
		'maintenance_contract_id',
		'elevator_id',
		'scheduled_date',
		'status',
		'notes',
		'company_id',
		'user_id',
		'invoice_id',
		'team_id'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function elevator()
	{
		return $this->belongsTo(Elevator::class);
	}

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}

	public function maintenance_contract()
	{
		return $this->belongsTo(MaintenanceContract::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function maintenance_logs()
	{
		return $this->hasMany(MaintenanceLog::class);
	}

	// Alias for maintenance_contract to maintain compatibility
	public function maintenanceContract()
	{
		return $this->belongsTo(MaintenanceContract::class, 'maintenance_contract_id');
	}

	/**
	 * Get the team assigned to this maintenance schedule.
	 */
	public function team()
	{
		return $this->belongsTo(MaintenanceTeam::class, 'team_id');
	}
}
