<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class MaintenanceLog
 * 
 * @property int $id
 * @property int|null $maintenance_schedule_id
 * @property int $elevator_id
 * @property Carbon $maintenance_date
 * @property int $technician_id
 * @property string $status
 * @property string|null $issues_found
 * @property string|null $actions_taken
 * @property string|null $parts_replaced
 * @property string|null $next_maintenance_recommendation
 * @property int $company_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Elevator $elevator
 * @property MaintenanceSchedule|null $maintenance_schedule
 * @property User $user
 *
 * @package App\Models
 */
class MaintenanceLog extends Model
{
	protected $table = 'maintenance_logs';

	protected $casts = [
		'maintenance_schedule_id' => 'int',
		'elevator_id' => 'int',
		'maintenance_date' => 'datetime',
		'technician_id' => 'int',
		'company_id' => 'int'
	];

	protected $fillable = [
		'maintenance_schedule_id',
		'elevator_id',
		'maintenance_date',
		'technician_id',
		'status',
		'issues_found',
		'actions_taken',
		'parts_replaced',
		'next_maintenance_recommendation',
		'company_id'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function elevator()
	{
		return $this->belongsTo(Elevator::class);
	}

	public function maintenance_schedule()
	{
		return $this->belongsTo(MaintenanceSchedule::class);
	}

	/**
	 * العلاقة مع جدول الصيانة (بنمط camelCase)
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function maintenanceSchedule()
	{
		return $this->belongsTo(MaintenanceSchedule::class, 'maintenance_schedule_id');
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'technician_id');
	}

	/**
	 * العلاقة مع الفني
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function technician()
	{
		return $this->belongsTo(User::class, 'technician_id');
	}
}
