<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class MaintenanceContract
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int|null $user_id
 * @property int|null $branch_id
 * @property string $contract_number
 * @property string $title
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property float $total_amount
 * @property string $billing_cycle
 * @property string $status
 * @property int $visits_per_year
 * @property string|null $terms_conditions
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Branch|null $branch
 * @property Company $company
 * @property Customer $customer
 * @property User|null $user
 * @property Collection|ContractElevator[] $contract_elevators
 * @property Collection|Invoice[] $invoices
 * @property Collection|MaintenanceSchedule[] $maintenance_schedules
 *
 * @package App\Models
 */
class MaintenanceContract extends Model
{
	use SoftDeletes;
	protected $table = 'maintenance_contracts';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'user_id' => 'int',
		'branch_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'total_amount' => 'float',
		'visits_per_year' => 'int'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'user_id',
		'branch_id',
		'contract_number',
		'title',
		'start_date',
		'end_date',
		'total_amount',
		'billing_cycle',
		'status',
		'visits_per_year',
		'terms_conditions',
		'notes'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function contract_elevators()
	{
		return $this->hasMany(ContractElevator::class);
	}

	public function invoices()
	{
		return $this->hasMany(Invoice::class);
	}

	public function maintenance_schedules()
	{
		return $this->hasMany(MaintenanceSchedule::class);
	}

	public function elevators()
	{
		return $this->belongsToMany(Elevator::class, 'contract_elevator', 'maintenance_contract_id', 'elevator_id');
	}
}
