<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceAttachment extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'maintenance_id',
        'name',
        'path',
        'mime_type',
        'size',
        'description',
        'uploaded_by',
    ];

    /**
     * Get the maintenance that owns the attachment.
     */
    public function maintenance()
    {
        return $this->belongsTo(ElevatorMaintenance::class, 'maintenance_id');
    }

    /**
     * Get the user who uploaded the attachment.
     */
    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}
