<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class LoyaltyPoint
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int $points
 * @property string $type
 * @property int $amount
 * @property string|null $source
 * @property int|null $source_id
 * @property string|null $description
 * @property Carbon|null $expiry_date
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Customer $customer
 *
 * @package App\Models
 */
class LoyaltyPoint extends Model
{
	use SoftDeletes;
	protected $table = 'loyalty_points';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'points' => 'int',
		'amount' => 'int',
		'source_id' => 'int',
		'expiry_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'points',
		'type',
		'amount',
		'source',
		'source_id',
		'description',
		'expiry_date'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}
}
