<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class LoginHistory
 * 
 * @property int $id
 * @property int|null $user_id
 * @property string $status
 * @property string $login_type
 * @property string|null $ip_address
 * @property string|null $browser
 * @property string|null $operating_system
 * @property string|null $device
 * @property string|null $user_agent
 * @property Carbon $login_at
 * @property Carbon|null $logout_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User|null $user
 *
 * @package App\Models
 */
class LoginHistory extends Model
{
	protected $table = 'login_history';

	protected $casts = [
		'user_id' => 'int',
		'login_at' => 'datetime',
		'logout_at' => 'datetime'
	];

	protected $fillable = [
		'user_id',
		'status',
		'login_type',
		'ip_address',
		'browser',
		'operating_system',
		'device',
		'user_agent',
		'login_at',
		'logout_at'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
