<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Location
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int|null $branch_id
 * @property string $name
 * @property string|null $address
 * @property string|null $city
 * @property string|null $state
 * @property string|null $country
 * @property string|null $postal_code
 * @property string|null $contact_person
 * @property string|null $contact_phone
 * @property string|null $contact_email
 * @property float|null $latitude
 * @property float|null $longitude
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property Customer $customer
 * @property Collection|Elevator[] $elevators
 * @property Collection|InstallationProject[] $installation_projects
 *
 * @package App\Models
 */
class Location extends Model
{
	use SoftDeletes;
	protected $table = 'locations';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'branch_id' => 'int',
		'latitude' => 'float',
		'longitude' => 'float'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'branch_id',
		'name',
		'address',
		'city',
		'state',
		'country',
		'postal_code',
		'contact_person',
		'contact_phone',
		'contact_email',
		'location_type',
		'latitude',
		'longitude',
		'google_maps_link',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function elevators()
	{
		return $this->hasMany(Elevator::class);
	}

	public function installation_projects()
	{
		return $this->hasMany(InstallationProject::class);
	}
}
