<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JournalTemplateItem extends Model
{
    use HasFactory;

    /**
     * الحقول القابلة للتعبئة الجماعية
     *
     * @var array
     */
    protected $fillable = [
        'journal_template_id',
        'account_id',
        'type',
        'percentage',
        'fixed_amount',
        'description'
    ];

    /**
     * الحقول التي يجب تحويلها إلى أنواع محددة
     *
     * @var array
     */
    protected $casts = [
        'percentage' => 'decimal:2',
        'fixed_amount' => 'decimal:2'
    ];

    /**
     * علاقة مع قالب القيد المحاسبي
     */
    public function journalTemplate()
    {
        return $this->belongsTo(JournalTemplate::class);
    }

    /**
     * علاقة مع الحساب
     */
    public function account()
    {
        return $this->belongsTo(ChartOfAccount::class, 'account_id');
    }

    /**
     * الحصول على اسم نوع البند بالعربية
     */
    public function getTypeNameAttribute()
    {
        return $this->type == 'debit' ? 'مدين' : 'دائن';
    }

    /**
     * نطاق للبنود المدينة
     */
    public function scopeDebit($query)
    {
        return $query->where('type', 'debit');
    }

    /**
     * نطاق للبنود الدائنة
     */
    public function scopeCredit($query)
    {
        return $query->where('type', 'credit');
    }

    /**
     * نطاق للبنود ذات النسبة المئوية
     */
    public function scopePercentage($query)
    {
        return $query->whereNotNull('percentage');
    }

    /**
     * نطاق للبنود ذات المبلغ الثابت
     */
    public function scopeFixedAmount($query)
    {
        return $query->whereNotNull('fixed_amount');
    }
}
