<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class JobTitle
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $department_id
 * @property string $name
 * @property string|null $name_en
 * @property string|null $code
 * @property string|null $description
 * @property float|null $min_salary
 * @property float|null $max_salary
 * @property string|null $responsibilities
 * @property string|null $requirements
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Company $company
 * @property Department|null $department
 *
 * @package App\Models
 */
class JobTitle extends Model
{
	use SoftDeletes;
	protected $table = 'job_titles';

	protected $casts = [
		'company_id' => 'int',
		'department_id' => 'int',
		'min_salary' => 'float',
		'max_salary' => 'float',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'department_id',
		'name',
		'name_en',
		'code',
		'description',
		'min_salary',
		'max_salary',
		'responsibilities',
		'requirements',
		'status',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function department()
	{
		return $this->belongsTo(Department::class);
	}
}
