<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InvoiceTemplate
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string $language
 * @property string|null $header_html
 * @property string|null $footer_html
 * @property string|null $css_styles
 * @property bool $is_default
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 *
 * @package App\Models
 */
class InvoiceTemplate extends Model
{
	protected $table = 'invoice_templates';

	protected $casts = [
		'company_id' => 'int',
		'is_default' => 'bool',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'language',
		'header_html',
		'footer_html',
		'css_styles',
		'is_default',
		'is_active'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}
}
