<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InvoiceItem
 * 
 * @property int $id
 * @property int $invoice_id
 * @property string $description
 * @property float $quantity
 * @property float $unit_price
 * @property float $discount_percentage
 * @property float $discount_amount
 * @property float $tax_percentage
 * @property float $tax_amount
 * @property float $subtotal
 * @property float $total
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Invoice $invoice
 *
 * @package App\Models
 */
class InvoiceItem extends Model
{
	protected $table = 'invoice_items';

	protected $casts = [
		'invoice_id' => 'int',
		'quantity' => 'float',
		'unit_price' => 'float',
		'discount_percentage' => 'float',
		'discount_amount' => 'float',
		'tax_percentage' => 'float',
		'tax_amount' => 'float',
		'subtotal' => 'float',
		'total' => 'float'
	];

	protected $fillable = [
		'invoice_id',
		'description',
		'quantity',
		'unit_price',
		'discount_percentage',
		'discount_amount',
		'tax_percentage',
		'tax_amount',
		'subtotal',
		'total'
	];

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}
}
