<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InvoiceInstallment
 * 
 * @property int $id
 * @property int $invoice_id
 * @property float $amount
 * @property Carbon $due_date
 * @property string $status
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Invoice $invoice
 *
 * @package App\Models
 */
class InvoiceInstallment extends Model
{
	protected $table = 'invoice_installments';

	protected $casts = [
		'invoice_id' => 'int',
		'amount' => 'float',
		'due_date' => 'datetime'
	];

	protected $fillable = [
		'invoice_id',
		'amount',
		'due_date',
		'status',
		'notes'
	];

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}
}
