<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Invoice
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int|null $maintenance_contract_id
 * @property int $branch_id
 * @property int|null $user_id
 * @property int $created_by
 * @property string $invoice_number
 * @property string $zatca_invoice_type
 * @property string|null $zatca_invoice_hash
 * @property string|null $zatca_qr_code
 * @property string|null $zatca_uuid
 * @property string|null $zatca_pih
 * @property string|null $zatca_xml_path
 * @property string|null $zatca_compliance_status
 * @property string|null $zatca_clearance_status
 * @property string|null $zatca_reporting_status
 * @property Carbon|null $zatca_reported_at
 * @property string|null $zatca_invoice_reference
 * @property string|null $zatca_previous_invoice_hash
 * @property bool $zatca_is_third_party_invoice
 * @property bool $zatca_is_nominal
 * @property bool $zatca_is_exports
 * @property bool $zatca_is_summary
 * @property bool $zatca_is_self_billed
 * @property Carbon $invoice_date
 * @property Carbon $due_date
 * @property float $subtotal
 * @property float $tax_rate
 * @property float $tax_amount
 * @property float $discount_percentage
 * @property float $discount_amount
 * @property float $total_amount
 * @property float $paid_amount
 * @property float $due_amount
 * @property string $status
 * @property string|null $notes
 * @property string|null $terms_conditions
 * @property int|null $template_id
 * @property string $language
 * @property bool $is_recurring
 * @property string|null $recurring_cycle
 * @property Carbon|null $next_recurring_date
 * @property int|null $parent_invoice_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Branch $branch
 * @property Company $company
 * @property User|null $user
 * @property Customer $customer
 * @property MaintenanceContract|null $maintenance_contract
 * @property Invoice|null $invoice
 * @property Collection|InvoiceInstallment[] $invoice_installments
 * @property Collection|InvoiceItem[] $invoice_items
 * @property Collection|Invoice[] $invoices
 * @property Collection|MaintenanceSchedule[] $maintenance_schedules
 * @property Collection|Payment[] $payments
 * @property Collection|ProjectPayment[] $project_payments
 * @property Collection|RewardRedemption[] $reward_redemptions
 * @property Collection|TaxReport[] $tax_reports
 *
 * @package App\Models
 */
class Invoice extends Model
{
	use SoftDeletes;
	protected $table = 'invoices';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'maintenance_contract_id' => 'int',
		'branch_id' => 'int',
		'user_id' => 'int',
		'created_by' => 'int',
		'zatca_reported_at' => 'datetime',
		'zatca_is_third_party_invoice' => 'bool',
		'zatca_is_nominal' => 'bool',
		'zatca_is_exports' => 'bool',
		'zatca_is_summary' => 'bool',
		'zatca_is_self_billed' => 'bool',
		'invoice_date' => 'datetime',
		'due_date' => 'datetime',
		'subtotal' => 'float',
		'tax_rate' => 'float',
		'tax_amount' => 'float',
		'discount_percentage' => 'float',
		'discount_amount' => 'float',
		'total_amount' => 'float',
		'paid_amount' => 'float',
		'due_amount' => 'float',
		'template_id' => 'int',
		'is_recurring' => 'bool',
		'next_recurring_date' => 'datetime',
		'parent_invoice_id' => 'int'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'maintenance_contract_id',
		'branch_id',
		'user_id',
		'created_by',
		'invoice_number',
		'zatca_invoice_type',
		'zatca_invoice_hash',
		'zatca_qr_code',
		'zatca_uuid',
		'zatca_pih',
		'zatca_xml_path',
		'zatca_compliance_status',
		'zatca_clearance_status',
		'zatca_reporting_status',
		'zatca_reported_at',
		'zatca_invoice_reference',
		'zatca_previous_invoice_hash',
		'zatca_is_third_party_invoice',
		'zatca_is_nominal',
		'zatca_is_exports',
		'zatca_is_summary',
		'zatca_is_self_billed',
		'invoice_date',
		'due_date',
		'subtotal',
		'tax_rate',
		'tax_amount',
		'discount_percentage',
		'discount_amount',
		'total_amount',
		'paid_amount',
		'due_amount',
		'status',
		'notes',
		'terms_conditions',
		'template_id',
		'language',
		'is_recurring',
		'recurring_cycle',
		'next_recurring_date',
		'parent_invoice_id'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function maintenance_contract()
	{
		return $this->belongsTo(MaintenanceContract::class);
	}

	public function invoice()
	{
		return $this->belongsTo(Invoice::class, 'parent_invoice_id');
	}

	public function invoice_installments()
	{
		return $this->hasMany(InvoiceInstallment::class);
	}

	public function invoice_items()
	{
		return $this->hasMany(InvoiceItem::class);
	}

	public function invoices()
	{
		return $this->hasMany(Invoice::class, 'parent_invoice_id');
	}

	public function maintenance_schedules()
	{
		return $this->hasMany(MaintenanceSchedule::class);
	}

	public function payments()
	{
		return $this->hasMany(Payment::class);
	}

	public function project_payments()
	{
		return $this->hasMany(ProjectPayment::class);
	}

	public function reward_redemptions()
	{
		return $this->hasMany(RewardRedemption::class);
	}

	public function tax_reports()
	{
		return $this->belongsToMany(TaxReport::class, 'tax_report_invoices')
			->withPivot('id')
			->withTimestamps();
	}

	/**
	 * Alias for invoice_items relationship
	 */
	public function items()
	{
		return $this->invoice_items();
	}

	/**
	 * Alias for invoice_installments relationship
	 */
	public function installments()
	{
		return $this->invoice_installments();
	}

	/**
	 * Relationship to InvoiceTemplate
	 */
	public function template()
	{
		return $this->belongsTo(InvoiceTemplate::class, 'template_id');
	}
}
