<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryValuation
 * 
 * @property int $id
 * @property int $company_id
 * @property int $item_id
 * @property int $warehouse_id
 * @property Carbon $valuation_date
 * @property float $quantity
 * @property float $unit_cost
 * @property float $total_cost
 * @property string $valuation_method
 * @property string|null $reference_type
 * @property int|null $reference_id
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User $user
 * @property InventoryItem $inventory_item
 * @property Warehouse $warehouse
 *
 * @package App\Models
 */
class InventoryValuation extends Model
{
	protected $table = 'inventory_valuations';

	protected $casts = [
		'company_id' => 'int',
		'item_id' => 'int',
		'warehouse_id' => 'int',
		'valuation_date' => 'datetime',
		'quantity' => 'float',
		'unit_cost' => 'float',
		'total_cost' => 'float',
		'reference_id' => 'int',
		'created_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'item_id',
		'warehouse_id',
		'valuation_date',
		'quantity',
		'unit_cost',
		'total_cost',
		'valuation_method',
		'reference_type',
		'reference_id',
		'created_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}
}
