<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryUnit
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string|null $name_en
 * @property string $code
 * @property string|null $description
 * @property bool $is_base
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Collection|InventoryItem[] $inventory_items
 * @property Collection|InventoryItemUnit[] $inventory_item_units
 *
 * @package App\Models
 */
class InventoryUnit extends Model
{
    protected $table = 'inventory_units';

    protected $casts = [
        'company_id' => 'int',
        'is_base' => 'bool',
        'is_active' => 'bool'
    ];

    protected $fillable = [
        'company_id',
        'name',
        'name_en',
        'code',
        'description',
        'is_base',
        'is_active'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function inventory_items()
    {
        return $this->hasMany(InventoryItem::class, 'base_unit_id');
    }

    public function inventory_item_units()
    {
        return $this->hasMany(InventoryItemUnit::class, 'unit_id');
    }
}
