<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryTransaction
 * 
 * @property int $id
 * @property int $company_id
 * @property string $transaction_type
 * @property int $item_id
 * @property int $warehouse_id
 * @property int|null $to_warehouse_id
 * @property float $quantity
 * @property float|null $unit_price
 * @property string|null $reference_number
 * @property string|null $reference_type
 * @property int|null $reference_id
 * @property int|null $batch_id
 * @property int|null $serial_id
 * @property int $created_by
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InventoryBatch|null $inventory_batch
 * @property Company $company
 * @property User $user
 * @property InventoryItem $inventory_item
 * @property InventorySerial|null $inventory_serial
 * @property Warehouse $warehouse
 *
 * @package App\Models
 */
class InventoryTransaction extends Model
{
	protected $table = 'inventory_transactions';

	protected $casts = [
		'company_id' => 'int',
		'item_id' => 'int',
		'warehouse_id' => 'int',
		'to_warehouse_id' => 'int',
		'quantity' => 'float',
		'unit_price' => 'float',
		'total_price' => 'float',
		'transaction_date' => 'datetime',
		'reference_id' => 'int',
		'batch_id' => 'int',
		'serial_id' => 'int',
		'created_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'transaction_type',
		'item_id',
		'warehouse_id',
		'to_warehouse_id',
		'quantity',
		'unit_price',
		'total_price',
		'transaction_date',
		'reference_number',
		'reference_type',
		'reference_id',
		'batch_id',
		'serial_id',
		'created_by',
		'notes'
	];

	public function inventory_batch()
	{
		return $this->belongsTo(InventoryBatch::class, 'batch_id');
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	/**
	 * علاقة اختصار للوصول إلى المستخدم الذي أنشأ الحركة
	 */
	public function creator()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function inventory_serial()
	{
		return $this->belongsTo(InventorySerial::class, 'serial_id');
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}

	/**
	 * علاقة المخزن المستلم (في حالة التحويل)
	 */
	public function toWarehouse()
	{
		return $this->belongsTo(Warehouse::class, 'to_warehouse_id');
	}

	/**
	 * علاقة اختصار للوصول إلى العنصر
	 */
	public function item()
	{
		return $this->inventory_item();
	}
}
