<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryStock
 * 
 * @property int $id
 * @property int $company_id
 * @property int $warehouse_id
 * @property int $item_id
 * @property float $quantity
 * @property float $reserved_quantity
 * @property string|null $location_code
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property InventoryItem $inventory_item
 * @property Warehouse $warehouse
 *
 * @package App\Models
 */
class InventoryStock extends Model
{
	protected $table = 'inventory_stocks';

	protected $casts = [
		'company_id' => 'int',
		'warehouse_id' => 'int',
		'item_id' => 'int',
		'quantity' => 'float',
		'reserved_quantity' => 'float'
	];

	protected $fillable = [
		'company_id',
		'warehouse_id',
		'item_id',
		'quantity',
		'reserved_quantity',
		'location_code'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}
}
