<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventorySerial
 * 
 * @property int $id
 * @property int $company_id
 * @property int $warehouse_id
 * @property int $item_id
 * @property int|null $batch_id
 * @property string $serial_number
 * @property string $status
 * @property Carbon|null $purchase_date
 * @property Carbon|null $warranty_expiry
 * @property float $purchase_price
 * @property int|null $supplier_id
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InventoryBatch|null $inventory_batch
 * @property Company $company
 * @property InventoryItem $inventory_item
 * @property Supplier|null $supplier
 * @property Warehouse $warehouse
 * @property Collection|InventoryTransaction[] $inventory_transactions
 *
 * @package App\Models
 */
class InventorySerial extends Model
{
	protected $table = 'inventory_serials';

	protected $casts = [
		'company_id' => 'int',
		'warehouse_id' => 'int',
		'item_id' => 'int',
		'batch_id' => 'int',
		'purchase_date' => 'datetime',
		'warranty_expiry' => 'datetime',
		'purchase_price' => 'float',
		'supplier_id' => 'int'
	];

	protected $fillable = [
		'company_id',
		'warehouse_id',
		'item_id',
		'batch_id',
		'serial_number',
		'status',
		'purchase_date',
		'warranty_expiry',
		'purchase_price',
		'supplier_id',
		'notes'
	];

	public function inventory_batch()
	{
		return $this->belongsTo(InventoryBatch::class, 'batch_id');
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function supplier()
	{
		return $this->belongsTo(Supplier::class);
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}

	public function inventory_transactions()
	{
		return $this->hasMany(InventoryTransaction::class, 'serial_id');
	}
}
