<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryItemUnit
 * 
 * @property int $id
 * @property int $item_id
 * @property int $unit_id
 * @property float $conversion_factor
 * @property bool $is_default
 * @property bool $is_purchase_unit
 * @property bool $is_sales_unit
 * @property bool $is_inventory_unit
 * @property float $purchase_price
 * @property float $selling_price
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InventoryItem $inventory_item
 * @property InventoryUnit $inventory_unit
 *
 * @package App\Models
 */
class InventoryItemUnit extends Model
{
    protected $table = 'inventory_item_units';

    protected $casts = [
        'item_id' => 'int',
        'unit_id' => 'int',
        'conversion_factor' => 'float',
        'is_default' => 'bool',
        'is_purchase_unit' => 'bool',
        'is_sales_unit' => 'bool',
        'is_inventory_unit' => 'bool',
        'purchase_price' => 'float',
        'selling_price' => 'float'
    ];

    protected $fillable = [
        'item_id',
        'unit_id',
        'conversion_factor',
        'is_default',
        'is_purchase_unit',
        'is_sales_unit',
        'is_inventory_unit',
        'purchase_price',
        'selling_price'
    ];

    public function inventory_item()
    {
        return $this->belongsTo(InventoryItem::class, 'item_id');
    }

    public function inventory_unit()
    {
        return $this->belongsTo(InventoryUnit::class, 'unit_id');
    }
}
