<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryIssueItem extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'inventory_issue_id',
        'inventory_item_id',
        'unit_id',
        'quantity',
        'notes'
    ];

    protected $casts = [
        'quantity' => 'float'
    ];

    protected $dates = [
        'deleted_at'
    ];

    // العلاقة مع إذن الصرف
    public function inventoryIssue()
    {
        return $this->belongsTo(InventoryIssue::class);
    }

    // العلاقة مع عنصر المخزون
    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItem::class);
    }

    // اختصار للوصول إلى عنصر المخزون
    public function item()
    {
        return $this->inventoryItem();
    }

    // العلاقة مع وحدة الصنف
    public function unit()
    {
        return $this->belongsTo(InventoryUnit::class, 'unit_id');
    }
}
