<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryIssue extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_id',
        'work_order_id',
        'warehouse_id',
        'user_id',
        'issue_number',
        'issue_date',
        'status',
        'notes'
    ];

    protected $dates = [
        'issue_date',
        'deleted_at'
    ];

    // العلاقة مع الشركة
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    // العلاقة مع أمر الشغل
    public function workOrder()
    {
        return $this->belongsTo(WorkOrder::class);
    }

    // العلاقة مع المستودع
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    // العلاقة مع المستخدم الذي أنشأ الإذن
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // العلاقة مع بنود إذن الصرف
    public function items()
    {
        return $this->hasMany(InventoryIssueItem::class);
    }

    // دالة مساعدة لعرض حالة إذن الصرف بالعربية
    public function getStatusTextAttribute()
    {
        $statuses = [
            'draft' => 'مسودة',
            'pending' => 'قيد الانتظار',
            'approved' => 'معتمد',
            'completed' => 'معتمد ومكتمل',
            'cancelled' => 'ملغي'
        ];

        return $statuses[$this->status] ?? $this->status;
    }
}
