<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryCategory
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string $code
 * @property int|null $parent_id
 * @property string|null $description
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property InventoryCategory|null $inventory_category
 * @property Collection|InventoryCategory[] $inventory_categories
 * @property Collection|InventoryItem[] $inventory_items
 *
 * @package App\Models
 */
class InventoryCategory extends Model
{
	protected $table = 'inventory_categories';

	protected $casts = [
		'company_id' => 'int',
		'parent_id' => 'int',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'code',
		'parent_id',
		'description',
		'is_active'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function inventory_category()
	{
		return $this->belongsTo(InventoryCategory::class, 'parent_id');
	}

	public function inventory_categories()
	{
		return $this->hasMany(InventoryCategory::class, 'parent_id');
	}

	public function inventory_items()
	{
		return $this->hasMany(InventoryItem::class, 'category_id');
	}
}
