<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InventoryBatch
 * 
 * @property int $id
 * @property int $company_id
 * @property int $warehouse_id
 * @property int $item_id
 * @property string $batch_number
 * @property float $quantity
 * @property Carbon|null $manufacturing_date
 * @property Carbon|null $expiry_date
 * @property float $purchase_price
 * @property int|null $supplier_id
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property InventoryItem $inventory_item
 * @property Supplier|null $supplier
 * @property Warehouse $warehouse
 * @property Collection|InventorySerial[] $inventory_serials
 * @property Collection|InventoryTransaction[] $inventory_transactions
 *
 * @package App\Models
 */
class InventoryBatch extends Model
{
	protected $table = 'inventory_batches';

	protected $casts = [
		'company_id' => 'int',
		'warehouse_id' => 'int',
		'item_id' => 'int',
		'quantity' => 'float',
		'manufacturing_date' => 'datetime',
		'expiry_date' => 'datetime',
		'purchase_price' => 'float',
		'supplier_id' => 'int'
	];

	protected $fillable = [
		'company_id',
		'warehouse_id',
		'item_id',
		'batch_number',
		'quantity',
		'manufacturing_date',
		'expiry_date',
		'purchase_price',
		'supplier_id',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function supplier()
	{
		return $this->belongsTo(Supplier::class);
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}

	public function inventory_serials()
	{
		return $this->hasMany(InventorySerial::class, 'batch_id');
	}

	public function inventory_transactions()
	{
		return $this->hasMany(InventoryTransaction::class, 'batch_id');
	}
}
