<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InventoryAlert extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'low_stock_enabled',
        'low_stock_threshold',
        'expiry_enabled',
        'expiry_threshold_days',
        'notification_emails',
        'notification_users',
    ];

    protected $casts = [
        'low_stock_enabled' => 'boolean',
        'low_stock_threshold' => 'float',
        'expiry_enabled' => 'boolean',
        'expiry_threshold_days' => 'integer',
        'notification_emails' => 'array',
        'notification_users' => 'array',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
