<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class InteractionFollowUp
 * 
 * @property int $id
 * @property int $interaction_id
 * @property int $user_id
 * @property Carbon $follow_up_date
 * @property string $notes
 * @property string $outcome
 * @property Carbon|null $next_follow_up_date
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property CustomerInteraction $interaction
 * @property User $user
 *
 * @package App\Models
 */
class InteractionFollowUp extends Model
{
    use HasFactory;

    protected $table = 'interaction_follow_ups';

    protected $fillable = [
        'interaction_id',
        'user_id',
        'follow_up_date',
        'notes',
        'outcome',
        'next_follow_up_date'
    ];

    protected $casts = [
        'interaction_id' => 'int',
        'user_id' => 'int',
        'follow_up_date' => 'datetime',
        'next_follow_up_date' => 'datetime'
    ];

    /**
     * العلاقة مع التفاعل الأصلي
     */
    public function interaction()
    {
        return $this->belongsTo(CustomerInteraction::class, 'interaction_id');
    }

    /**
     * العلاقة مع المستخدم الذي قام بالمتابعة
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
