<?php

namespace App\Models\HRM;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingParticipant extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'training_id',
        'employee_id',
        'status',
        'attendance_status',
        'score',
        'feedback',
        'certificate_issued',
        'certificate_number',
        'certificate_date',
        'certificate_file',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'certificate_date' => 'date',
        'score' => 'decimal:2',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع التدريب
     */
    public function training()
    {
        return $this->belongsTo(Training::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * العلاقة مع المستخدم الذي أنشأ المشاركة
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * العلاقة مع المستخدم الذي قام بتحديث المشاركة
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
