<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayrollItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'payroll_id',
        'employee_id',
        'basic_salary',
        'housing_allowance',
        'transportation_allowance',
        'other_allowances',
        'overtime_hours',
        'overtime_amount',
        'bonus',
        'deductions',
        'loan_deductions',
        'tax_deductions',
        'insurance_deductions',
        'absence_deductions',
        'other_deductions',
        'net_salary',
        'payment_method',
        'payment_status',
        'payment_date',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'payment_date' => 'date',
        'basic_salary' => 'decimal:2',
        'housing_allowance' => 'decimal:2',
        'transportation_allowance' => 'decimal:2',
        'other_allowances' => 'decimal:2',
        'overtime_hours' => 'decimal:2',
        'overtime_amount' => 'decimal:2',
        'bonus' => 'decimal:2',
        'deductions' => 'decimal:2',
        'loan_deductions' => 'decimal:2',
        'tax_deductions' => 'decimal:2',
        'insurance_deductions' => 'decimal:2',
        'absence_deductions' => 'decimal:2',
        'other_deductions' => 'decimal:2',
        'net_salary' => 'decimal:2',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع كشف الرواتب
     */
    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * حساب إجمالي البدلات
     */
    public function getTotalAllowancesAttribute()
    {
        return $this->housing_allowance + $this->transportation_allowance + $this->other_allowances + $this->overtime_amount + $this->bonus;
    }

    /**
     * حساب إجمالي الخصومات
     */
    public function getTotalDeductionsAttribute()
    {
        return $this->deductions + $this->loan_deductions + $this->tax_deductions + $this->insurance_deductions + $this->absence_deductions + $this->other_deductions;
    }
}
