<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoanInstallment extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'loan_id',
        'employee_id',
        'payroll_item_id',
        'installment_number',
        'amount',
        'due_date',
        'payment_date',
        'status',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'due_date' => 'date',
        'payment_date' => 'date',
    ];

    /**
     * حالات القسط
     */
    const STATUSES = [
        'pending' => 'قيد الانتظار',
        'paid' => 'مدفوع',
        'overdue' => 'متأخر',
        'cancelled' => 'ملغي'
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع القرض
     */
    public function loan()
    {
        return $this->belongsTo(Loan::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * العلاقة مع عنصر الراتب
     */
    public function payrollItem()
    {
        return $this->belongsTo(PayrollItem::class);
    }

    /**
     * الحصول على اسم حالة القسط
     */
    public function getStatusNameAttribute()
    {
        return self::STATUSES[$this->status] ?? $this->status;
    }

    /**
     * التحقق مما إذا كان القسط متأخرًا
     */
    public function getIsOverdueAttribute()
    {
        return $this->status === 'pending' && $this->due_date < now()->startOfDay();
    }
}
