<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveType extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'leave_types';

    protected $fillable = [
        'company_id',
        'name',
        'name_en',
        'code',
        'days_per_year',
        'is_paid',
        'carry_forward',
        'max_carry_forward_days',
        'description',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'is_paid' => 'boolean',
        'carry_forward' => 'boolean',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع الإجازات
     */
    public function leaves()
    {
        return $this->hasMany(Leave::class);
    }
}
