<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobTitle extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_id',
        'department_id',
        'name',
        'name_en',
        'code',
        'description',
        'responsibilities',
        'requirements',
        'min_salary',
        'max_salary',
        'status',
        'created_by',
        'updated_by'
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع القسم
     */
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    /**
     * العلاقة مع الموظفين
     */
    public function employees()
    {
        return $this->hasMany(Employee::class);
    }
}
