<?php

namespace App\Models\HRM;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeTaskComment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_id',
        'task_id',
        'user_id',
        'comment',
        'created_by',
        'updated_by'
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع المهمة
     */
    public function task()
    {
        return $this->belongsTo(EmployeeTask::class, 'task_id');
    }

    /**
     * العلاقة مع المستخدم الذي كتب التعليق
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * العلاقة مع المستخدم الذي أنشأ التعليق
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * العلاقة مع المستخدم الذي قام بتحديث التعليق
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
