<?php

namespace App\Models\HRM;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeTaskAssignee extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'task_id',
        'employee_id',
        'status',
        'progress',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'progress' => 'integer',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع المهمة
     */
    public function task()
    {
        return $this->belongsTo(EmployeeTask::class, 'task_id');
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * العلاقة مع المستخدم الذي أنشأ التكليف
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * العلاقة مع المستخدم الذي قام بتحديث التكليف
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
