<?php

namespace App\Models\HRM;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeEvaluation extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'evaluator_id',
        'evaluation_date',
        'evaluation_period',
        'performance_score',
        'attendance_score',
        'quality_score',
        'teamwork_score',
        'initiative_score',
        'communication_score',
        'leadership_score',
        'technical_score',
        'total_score',
        'strengths',
        'areas_for_improvement',
        'goals',
        'comments',
        'employee_comments',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'evaluation_date' => 'date',
        'strengths' => 'array',
        'areas_for_improvement' => 'array',
        'goals' => 'array',
        'performance_score' => 'decimal:2',
        'attendance_score' => 'decimal:2',
        'quality_score' => 'decimal:2',
        'teamwork_score' => 'decimal:2',
        'initiative_score' => 'decimal:2',
        'communication_score' => 'decimal:2',
        'leadership_score' => 'decimal:2',
        'technical_score' => 'decimal:2',
        'total_score' => 'decimal:2',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * العلاقة مع المقيم
     */
    public function evaluator()
    {
        return $this->belongsTo(User::class, 'evaluator_id');
    }
}
