<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeDocument extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'document_type',
        'title',
        'file_path',
        'expiry_date',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'expiry_date' => 'date',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
