<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Department extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_id',
        'name',
        'name_en',
        'code',
        'description',
        'parent_id',
        'manager_id',
        'status',
        'created_by',
        'updated_by'
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع القسم الأب
     */
    public function parent()
    {
        return $this->belongsTo(Department::class, 'parent_id');
    }

    /**
     * العلاقة مع الأقسام الفرعية
     */
    public function children()
    {
        return $this->hasMany(Department::class, 'parent_id');
    }

    /**
     * العلاقة مع مدير القسم
     */
    public function manager()
    {
        return $this->belongsTo(Employee::class, 'manager_id');
    }

    /**
     * العلاقة مع الموظفين في القسم
     */
    public function employees()
    {
        return $this->hasMany(Employee::class);
    }

    /**
     * العلاقة مع المسميات الوظيفية في القسم
     */
    public function jobTitles()
    {
        return $this->hasMany(JobTitle::class);
    }
}
