<?php

namespace App\Models\HRM;

use App\Models\Company;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bonus extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'bonus_type',
        'amount',
        'date',
        'description',
        'status',
        'approved_by',
        'approved_at',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'date' => 'date',
        'amount' => 'decimal:2',
        'approved_at' => 'datetime',
    ];

    /**
     * أنواع المكافآت المتاحة
     */
    const BONUS_TYPES = [
        'performance' => 'مكافأة أداء',
        'project' => 'مكافأة مشروع',
        'annual' => 'مكافأة سنوية',
        'incentive' => 'حافز',
        'other' => 'أخرى'
    ];

    /**
     * حالات المكافأة
     */
    const STATUSES = [
        'pending' => 'قيد الانتظار',
        'approved' => 'معتمدة',
        'rejected' => 'مرفوضة',
        'paid' => 'مدفوعة'
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * العلاقة مع المستخدم الذي وافق على المكافأة
     */
    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    /**
     * العلاقة مع المستخدم الذي أنشأ المكافأة
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * الحصول على اسم نوع المكافأة
     */
    public function getBonusTypeNameAttribute()
    {
        return self::BONUS_TYPES[$this->bonus_type] ?? $this->bonus_type;
    }

    /**
     * الحصول على اسم حالة المكافأة
     */
    public function getStatusNameAttribute()
    {
        return self::STATUSES[$this->status] ?? $this->status;
    }
}
