<?php

namespace App\Models\HRM;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'date',
        'check_in',
        'check_out',
        'late_minutes',
        'overtime_minutes',
        'total_hours',
        'status',
        'notes',
        'location_check_in',
        'location_check_out',
        'ip_address_check_in',
        'ip_address_check_out',
        'device_check_in',
        'device_check_out',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'date' => 'date',
        'check_in' => 'datetime',
        'check_out' => 'datetime',
        'location_check_in' => 'array',
        'location_check_out' => 'array',
        'total_hours' => 'decimal:2',
    ];

    /**
     * العلاقة مع الشركة
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * العلاقة مع الموظف
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
