<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class FinancialReport
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $branch_id
 * @property string $report_type
 * @property string $name
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property string|null $parameters
 * @property string|null $data
 * @property string|null $file_path
 * @property int|null $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Branch|null $branch
 * @property Company $company
 * @property User|null $user
 *
 * @package App\Models
 */
class FinancialReport extends Model
{
	protected $table = 'financial_reports';

	protected $casts = [
		'company_id' => 'int',
		'branch_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'created_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'branch_id',
		'report_type',
		'name',
		'start_date',
		'end_date',
		'parameters',
		'data',
		'file_path',
		'created_by'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}
}
