<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeTaskAssignee extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'task_id',
        'employee_id',
    ];

    /**
     * Get the task that owns the assignee.
     */
    public function task()
    {
        return $this->belongsTo(EmployeeTask::class, 'task_id');
    }

    /**
     * Get the employee that owns the assignee.
     */
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
