<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeEvaluation extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'employee_id',
        'evaluator_id',
        'evaluation_date',
        'evaluation_period',
        'performance_score',
        'attendance_score',
        'quality_score',
        'teamwork_score',
        'initiative_score',
        'communication_score',
        'leadership_score',
        'technical_score',
        'total_score',
        'strengths',
        'areas_for_improvement',
        'goals',
        'comments',
        'employee_comments',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'evaluation_date' => 'date',
        'strengths' => 'array',
        'areas_for_improvement' => 'array',
        'goals' => 'array',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function evaluator()
    {
        return $this->belongsTo(User::class, 'evaluator_id');
    }

    public function scopeByCompany($query, $companyId)
    {
        return $query->where('company_id', $companyId);
    }

    public function scopeByEmployee($query, $employeeId)
    {
        return $query->where('employee_id', $employeeId);
    }

    public function scopeByEvaluator($query, $evaluatorId)
    {
        return $query->where('evaluator_id', $evaluatorId);
    }

    public function scopeByPeriod($query, $period)
    {
        return $query->where('evaluation_period', $period);
    }

    public function scopeDraft($query)
    {
        return $query->where('status', 'draft');
    }

    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }

    public function scopeAcknowledged($query)
    {
        return $query->where('status', 'acknowledged');
    }
}
