<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Employee
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $branch_id
 * @property int|null $department_id
 * @property int|null $job_title_id
 * @property int|null $user_id
 * @property string $employee_number
 * @property string $first_name
 * @property string $last_name
 * @property string|null $first_name_en
 * @property string|null $last_name_en
 * @property string|null $national_id
 * @property string|null $passport_number
 * @property Carbon|null $passport_expiry
 * @property string|null $nationality
 * @property Carbon|null $birth_date
 * @property string|null $gender
 * @property string|null $marital_status
 * @property string|null $phone
 * @property string|null $emergency_contact
 * @property string|null $address
 * @property string|null $email
 * @property Carbon $join_date
 * @property Carbon|null $probation_end_date
 * @property Carbon|null $contract_end_date
 * @property float $basic_salary
 * @property float $housing_allowance
 * @property float $transportation_allowance
 * @property float $other_allowances
 * @property string|null $bank_name
 * @property string|null $bank_account
 * @property string|null $iban
 * @property string|null $education_level
 * @property string|null $education_field
 * @property string|null $skills
 * @property string|null $notes
 * @property string $status
 * @property string|null $profile_picture
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Branch|null $branch
 * @property Company $company
 * @property Collection|PayrollItem[] $payroll_items
 *
 * @package App\Models
 */
class Employee extends Model
{
	use SoftDeletes;
	protected $table = 'employees';

	protected $casts = [
		'company_id' => 'int',
		'branch_id' => 'int',
		'department_id' => 'int',
		'job_title_id' => 'int',
		'user_id' => 'int',
		'passport_expiry' => 'datetime',
		'birth_date' => 'datetime',
		'join_date' => 'datetime',
		'probation_end_date' => 'datetime',
		'contract_end_date' => 'datetime',
		'basic_salary' => 'float',
		'housing_allowance' => 'float',
		'transportation_allowance' => 'float',
		'other_allowances' => 'float',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'branch_id',
		'department_id',
		'job_title_id',
		'user_id',
		'employee_number',
		'first_name',
		'last_name',
		'first_name_en',
		'last_name_en',
		'national_id',
		'passport_number',
		'passport_expiry',
		'nationality',
		'birth_date',
		'gender',
		'marital_status',
		'phone',
		'emergency_contact',
		'address',
		'email',
		'join_date',
		'probation_end_date',
		'contract_end_date',
		'basic_salary',
		'housing_allowance',
		'transportation_allowance',
		'other_allowances',
		'bank_name',
		'bank_account',
		'iban',
		'education_level',
		'education_field',
		'skills',
		'notes',
		'status',
		'profile_picture',
		'created_by',
		'updated_by'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function payroll_items()
	{
		return $this->hasMany(PayrollItem::class);
	}

	public function department()
	{
		return $this->belongsTo(Department::class);
	}

	public function jobTitle()
	{
		return $this->belongsTo(JobTitle::class);
	}

	public function attendances()
	{
		return $this->hasMany(Attendance::class);
	}
}
